﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using System;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests
{
    [TestClass]
    public class BprDeploymentManagerTests : DeploymentFactoryTestBase
    {
        private BprDeploymentManager _cut;

        [TestInitialize]
        public void MyTestInitialize()
        {
            _cut = new BprDeploymentManager();
        }
        [TestMethod]
        public void CreateDeployment_Will_Use_MajorBodyOfWater_For_Location_If_Present()
        {
            var location = new DeploymentLocation
            {
                deploymentLocationMajorBodyOfWaterCode = "6P",
                deploymentLocationBeginDate = DateTime.Parse("2006-01-12"),
                deploymentLocationEndDate = DateTime.Parse("2006-05-13"),
            };
            var actual = _cut.CreateDeployment("n", location);
            Assert.AreEqual("6P", actual.deploymentCountryCode);
        }
        [TestMethod]
        public void CreateDeployment_Should_Use_DeploymentCountry_For_Location_If_Present()
        {
            var location = new DeploymentLocation
            {
                deploymentCountry = "IZ",
                deploymentLocationBeginDate = DateTime.Parse("2006-01-12"),
                deploymentLocationEndDate = DateTime.Parse("2006-05-13"),
            };
            var actual = _cut.CreateDeployment("n", location);
            Assert.AreEqual("IZ", actual.deploymentCountryCode);
        }
        [TestMethod]
        public void CreateDeployment_Not_Null_When_Given_Valid_Data()
        {
            DeploymentLocation loc = CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30");

            BprDoDDeployment actual = _cut.CreateDeployment("a", loc);
            Assert.IsNotNull(actual);
        }
        [TestMethod]
        public void CreateDeployment_Should_Process_A_Deployment_With_No_End_Date()
        {
            DeploymentLocation loc = CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30");

            BprDoDDeployment actual = _cut.CreateDeployment("a", loc);
            Assert.IsNotNull(actual);
        }
        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void Create_Deployment_Throws_ArgumentNullException_When_DeploymentLocation_Is_Null()
        {

            BprDoDDeployment actual = _cut.CreateDeployment("a", null);
            Assert.IsNotNull(actual);
        }
        [TestMethod]
        public void Create_Deployment_Should_Have_Correct_DeploymentLocation_Info()
        {
            DeploymentLocation loc = CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30");

            BprDoDDeployment actual = _cut.CreateDeployment("a", loc);
            Assert.AreEqual("KU", actual.deploymentCountryCode);
            Assert.AreEqual("a", actual.branchOfService);
            Assert.AreEqual("7/30/2006", actual.deploymentEndDate);
            Assert.AreEqual("7/29/2006", actual.deploymentStartDate);
        }
        [TestMethod]
        public void CreateDeployment_Should_Return_DeploymentEndDate_Of_11_11_9999_For_Registrant_With_DeploymentEndDate_Of_01_01_0001()
        {
          
            var location = new DeploymentLocation
            {
                deploymentLocationMajorBodyOfWaterCode = "6P",
                deploymentLocationBeginDate = DateTime.Parse("2006-01-12"),
                deploymentLocationEndDate = DateTime.Parse("0001-01-01"),
            };
            var actual = _cut.CreateDeployment("n", location);
            Assert.AreEqual(DateTime.Parse("9999-11-11").ToShortDateString(), actual.deploymentEndDate);
        }
        [TestMethod]
        public void GetBprDoDDeploymentImports_Doesnt_Puke_When_Casting_IDeployment_To_Array_of_BprDoDDeployment()
        {
            string edipi = "1005136624";
            string ssn = string.Empty;
            var regManager = new AHOBPRRegistrantManager(sqlConnection);
            var reg = regManager.GetRegistrantById(edipi, ssn);
            var manager = new BprDeploymentManager(sqlConnection);
           var whatever =  manager.GetBprDoDDeploymentImports(reg);
        }


        //private DeploymentLocation CreateDeploymentLocation(string country, string beginDate, string endDate)
        //{
        //    return new DeploymentLocation
        //    {
        //        deploymentCountry = country,
        //        deploymentLocationBeginDate = DateTime.Parse(beginDate),
        //        deploymentLocationEndDate = DateTime.Parse(endDate),
        //    };
        //}
        public Deployment[] CreateDeploymentTestData()
        {
            Deployment depOne = new Deployment
            {

                deploymentData = new DeploymentData
                {
                    DeploymentLocation = CreateDeploymentLocations(),
                    deploymentStartDate = DateTime.Parse("2005-11-01"),
                    deploymentEndDate = DateTime.Parse("2006-11-29")
                }
            };
            return new Deployment[] { depOne };
        }


        private DeploymentLocation[] CreateDeploymentLocations()
        {
            var locOne = CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30");

            var locTwo = new DeploymentLocation
            {
                deploymentCountry = "IZ",
                deploymentLocationBeginDate = DateTime.Parse("2006-01-12"),
                deploymentLocationEndDate = DateTime.Parse("2006-05-13"),
            };
            return new DeploymentLocation[] { locOne, locTwo };
        }
    }
}
